function [x, y ,z] = readX3P_parallel(filename)

% an X3P file can be considerd as zipped file that consists of
% - bindata folder, main.xml file and md5checksum.hex

files = listzipcontents(filename); 

% Installed and used third party 7z.exe to unzip the X3P file
[status,result] = system(['"C:\Program Files\7-Zip\7z.exe" -y x ' '"' filename '"']);

files=files';

[rr cc]=size(files);

pat= 'main.xml';

d=[];
for i=1:cc
    D=strcmpi(files{i},pat);
    d(i)=D;
end
xt=find(d==1);

% Step 1 : parse XML file
B=parseXML(files{xt});% XML is converted to DOM structure for ease of parsing


% Step 2 : read size of file from main.xml file
SizeX=str2double(B.Children(6).Children(2).Children(2).Children.Data);
SizeY=str2double(B.Children(6).Children(2).Children(4).Children.Data);

% Step 3 : match binary file name to identify the binary file

% read the binary file pattern from the main.xml file
pat1= B.Children(6).Children(4).Children(2).Children.Data;

% To identify the bin file - pattern matching performed
% match strings obtained when x3p file unzipped in matlab and
% the bin file mentioned in the main xml file (represented as pat1 in this
% code). If no length match found in the files folder , no data bin file. If
% single length match found that is the file.

l1=length(pat1);
d1=[];q=[];
for i=1:cc
    stri= files{i};
    l=length(stri);
    if (l==l1)
       q=[q i];  % indices that have same length as pattern to be matched
    end
end
% If more than one file with file name length match with pattern found i.e.
% length(q)>1 , then do a character based match score. The file name with
% highest character match with pat1 is taken as the bin file for data
d1=zeros([1 length(files)]);yin=0;

if length(q)>1
  for i=1:length(q)
     l=length(files{q(i)});
      stri= files{q(i)}; 
      n=(stri==pat1);
      D=sum(n);
      d1(q(i))=D;
  end
    [ma indMa]=max(dl,[]);
    yin=indMa;
else
    yin=q;
end

fileID=fopen(files{yin});

% obtain the format for the data
dataType=B.Children(2).Children(6).Children(2).Children(4).Children.Data;
format='';

if dataType=='I'
    format='int16';
elseif dataType=='L'
     format='int32';
elseif dataType=='F'
      format='float32';
else
      format='float64';
end
        
%format = 'float32'; %or int32
Data = fread(fileID, Inf, format); % read file from data.bin using the prescribed format
DataR=reshape(Data,[SizeX SizeY]);
fclose(fileID);

%Conversion to grayscale image
z=DataR;
ZZ=z;
ZZ(isnan(ZZ))=0;
GIm1=uint8(255.* mat2gray(ZZ));


% X increment
r=[];
l=0;
for i=1:SizeX
    l1=l;
    l=l1+ str2double(B.Children(2).Children(6).Children(2).Children(6).Children.Data);
    r(i)=l1;
end
Xfull=repmat(r,[SizeY 1]);

% Y increment 
r1=[];
l=0;
for i=1:SizeY
    l1=l;
    l=l1+str2double(B.Children(2).Children(6).Children(4).Children(6).Children.Data);
    r1(i,1)=l1;
end
Yfull=repmat(r1,[1 SizeX]);


x=Xfull;
y=Yfull;
z=DataR;

end